<?php
require_once __DIR__ . '/auth.php';

$error = '';

if (is_logged_in()) {
    header('Location: index.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    global $pdo;

    $username = trim($_POST['username'] ?? '');
    $password = trim($_POST['password'] ?? '');

    if ($username === '' || $password === '') {
        $error = 'Por favor ingresa usuario y contraseña.';
    } else {
        $stmt = $pdo->prepare("SELECT id, username, password, nombre, rol, activo FROM usuarios WHERE username = :u LIMIT 1");
        $stmt->execute([':u' => $username]);
        $user = $stmt->fetch();

        if (!$user || (int)$user['activo'] !== 1) {
            $error = 'Usuario o contraseña incorrectos.';
        } else {
            // NOTA: en producción usar password_hash/password_verify.
            if ($user['password'] === $password) {
                $_SESSION['user_id']   = $user['id'];
                $_SESSION['user']      = $user['username'];
                $_SESSION['user_name'] = $user['nombre'] ?: $user['username'];
                $_SESSION['rol']       = $user['rol'] ?: 'usuario';

                header('Location: index.php');
                exit;
            } else {
                $error = 'Usuario o contraseña incorrectos.';
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Rituales - Calculadora de Proyecciones</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    :root {
      --rituales-primary: #5a3825;
      --rituales-primary-dark: #3d2518;
      --rituales-accent: #c58b57;
      --rituales-bg: #f7f1ea;
    }
    body {
      background: radial-gradient(circle at top, #fff7ec 0, var(--rituales-bg) 55%, #e4d4c3 100%);
      min-height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
    }
    .card-login {
      border-radius: 20px;
      border: none;
      box-shadow: 0 18px 40px rgba(0,0,0,0.15);
      max-width: 420px;
      width: 100%;
      background: #ffffff;
    }
    .brand-badge {
      background: rgba(90,56,37,0.06);
      border-radius: 999px;
      padding: 4px 12px;
      font-size: 11px;
      text-transform: uppercase;
      letter-spacing: 0.08em;
      color: #6c4a32;
      display: inline-flex;
      align-items: center;
      gap: 6px;
    }
    .brand-dot {
      width: 8px;
      height: 8px;
      border-radius: 999px;
      background: var(--rituales-accent);
    }
    .btn-rituales {
      background: var(--rituales-primary);
      border-color: var(--rituales-primary);
      color: #fff;
    }
    .btn-rituales:hover {
      background: var(--rituales-primary-dark);
      border-color: var(--rituales-primary-dark);
      color: #fff;
    }
    .form-control:focus {
      border-color: var(--rituales-accent);
      box-shadow: 0 0 0 0.2rem rgba(197,139,87,0.25);
    }
    .footer-note {
      font-size: 11px;
      color: #8c7969;
    }
  </style>
</head>
<body>
<div class="container px-3">
  <div class="card card-login p-4 p-md-4 mx-auto">
    <div class="text-center mb-3">
      <img src="logorituales.png" alt="Logo Rituales" class="img-fluid mb-2" style="max-width: 140px; height: auto;">
      <div class="brand-badge mt-1">
        <span class="brand-dot"></span>
        <span>Rituales · Panel financiero</span>
      </div>
    </div>

    <h1 class="h5 text-center mb-1">Calculadora de Proyecciones</h1>
    <p class="text-center text-muted mb-4">
      Ingresa para gestionar y analizar los reportes mensuales.
    </p>

    <?php if ($error): ?>
      <div class="alert alert-danger py-2 small"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form method="post" autocomplete="off">
      <div class="mb-3">
        <label class="form-label">Usuario</label>
        <input type="text" name="username" class="form-control" required autofocus>
      </div>
      <div class="mb-3">
        <label class="form-label">Contraseña</label>
        <input type="password" name="password" class="form-control" required>
      </div>
      <div class="d-grid mt-3">
        <button type="submit" class="btn btn-rituales">
          Ingresar
        </button>
      </div>
    </form>

    <p class="footer-note text-center mt-3 mb-0">
      Sistema interno de gestión financiera para franquicias Rituales.
    </p>
  </div>
</div>
</body>
</html>
