-- Script de base de datos para Calculadora de Proyecciones v3
-- Crea las tablas de usuarios y proyecciones.

CREATE TABLE IF NOT EXISTS usuarios (
  id INT AUTO_INCREMENT PRIMARY KEY,
  username VARCHAR(50) NOT NULL UNIQUE,
  password VARCHAR(255) NOT NULL,
  nombre VARCHAR(100) DEFAULT NULL,
  rol VARCHAR(50) DEFAULT 'usuario',
  activo TINYINT(1) NOT NULL DEFAULT 1,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Usuario por defecto: admin / admin123 (contraseña en texto plano en este ejemplo)
INSERT INTO usuarios (username, password, nombre, rol, activo)
VALUES ('admin', 'admin123', 'Administrador General', 'admin', 1)
ON DUPLICATE KEY UPDATE username = username;

CREATE TABLE IF NOT EXISTS proyecciones (
  id INT AUTO_INCREMENT PRIMARY KEY,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,

  franquicia VARCHAR(255) NOT NULL,
  responsable_nombre VARCHAR(255) NOT NULL,
  responsable_apellidos VARCHAR(255) NOT NULL,
  mes_analisis VARCHAR(100) NOT NULL,

  ventas_mes DECIMAL(15,2) NOT NULL,
  num_empleados INT NOT NULL,
  promedio_dia DECIMAL(15,2) NOT NULL,

  arriendo_admin DECIMAL(15,2) NOT NULL,
  nomina DECIMAL(15,2) NOT NULL,
  servicios_publicos DECIMAL(15,2) NOT NULL,
  contador DECIMAL(15,2) NOT NULL,
  calidad DECIMAL(15,2) NOT NULL,
  papeleria DECIMAL(15,2) NOT NULL,
  transporte_parqueadero DECIMAL(15,2) NOT NULL,
  impuestos DECIMAL(15,2) NOT NULL,
  mantenimiento DECIMAL(15,2) NOT NULL,
  mercadeo_activaciones DECIMAL(15,2) NOT NULL,
  plataformas DECIMAL(15,2) NOT NULL,
  aseo_insumos DECIMAL(15,2) NOT NULL,
  otros_gastos DECIMAL(15,2) NOT NULL,
  credito DECIMAL(15,2) NOT NULL,
  gastos_legales DECIMAL(15,2) NOT NULL,
  gastos_financieros DECIMAL(15,2) NOT NULL,
  total_gastos DECIMAL(15,2) NOT NULL,

  cafe DECIMAL(15,2) NOT NULL,
  leche DECIMAL(15,2) NOT NULL,
  frutas_verduras DECIMAL(15,2) NOT NULL,
  reposteria DECIMAL(15,2) NOT NULL,
  otros_costos DECIMAL(15,2) NOT NULL,
  total_costos DECIMAL(15,2) NOT NULL,
  porcentaje_costos DECIMAL(5,2) NOT NULL,

  inventario DECIMAL(15,2) NOT NULL,
  inventario_sugerido DECIMAL(15,2) NOT NULL,

  utilidad_bruta DECIMAL(15,2) NOT NULL,
  utilidad_operacional DECIMAL(15,2) NOT NULL,
  utilidad_neta DECIMAL(15,2) NOT NULL,
  utilidad_neta_menos_inventario DECIMAL(15,2) NOT NULL,
  utilidad_neta_menos_inv_sobre_ventas DECIMAL(5,2) NOT NULL,

  costo_produccion_pct DECIMAL(5,2) NOT NULL,
  part_arriendo_pct DECIMAL(5,2) NOT NULL,
  part_servicios_pct DECIMAL(5,2) NOT NULL,
  part_nomina_pct DECIMAL(5,2) NOT NULL,
  margen_neto_pct DECIMAL(5,2) NOT NULL,
  margen_operacional_pct DECIMAL(5,2) NOT NULL,
  part_cafe_pct DECIMAL(5,2) NOT NULL,
  part_leche_pct DECIMAL(5,2) NOT NULL,
  part_frutas_pct DECIMAL(5,2) NOT NULL,
  part_reposteria_pct DECIMAL(5,2) NOT NULL,
  part_otros_costos_pct DECIMAL(5,2) NOT NULL
);
